//
//  MCDataStore.h
//  MCClientServer
//
//  Created by Mark Onyschuk on 30/04/08.
//  Copyright 2008 Marketcircle, Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>


@class MCSyncHost, MCPModel;


@interface MCDataStore : NSObject {

	MCSyncHost *syncHost;
	MCPModel *model;
}

@property (nonatomic, assign) MCSyncHost *syncHost;
@property (nonatomic, retain) MCPModel *model;

@property (nonatomic, readonly, copy) id databaseID;

#pragma mark -
#pragma mark Opening and Closing the Database
- (BOOL)open;
- (BOOL)isOpen; // approx
- (BOOL)close;

- (NSString *)lastErrorMessage;

#pragma mark -
#pragma mark Transaction Support
- (BOOL)beginTransaction;
- (BOOL)commitTransaction;
- (BOOL)rollbackTransaction;

#pragma mark -
#pragma mark Insert/Update/Delete
- (BOOL)insertRow:(NSDictionary *)aDict table:(NSString *)aString;
- (BOOL)replaceRow:(NSDictionary *)aDict table:(NSString *)aString;
- (BOOL)updateRow:(NSDictionary *)aDict table:(NSString *)aString;
- (BOOL)deleteRow:(NSDictionary *)aDict table:(NSString *)aTable;

- (BOOL)insertRows:(NSArray *)anArray table:(NSString *)aTable;
- (BOOL)replaceRows:(NSArray *)anArray table:(NSString *)aTable;

#pragma mark -
#pragma mark Fetch
- (NSArray *)rowsForTable:(NSString *)aTable where:(NSString *)aWhereClause;

- (NSDictionary *)pruneDictionary:(NSDictionary *)inDictionary forTable:(NSString *)aTable;

#pragma mark -
#pragma mark Change Log Support
- (NSNumber *)tableIDForName:(NSString *)aName;
- (NSString *)tableNameForID:(NSNumber *)tableID;

@end
